<?php 
return [
    'en' => [
        'Name' => 'Woocommerce integration with Kommo',
        'Description' => 'The plugin allows you to configure orders transfer from Woocommerce to Kommo.',

        'curl_not_installed' => 'Curl is not installed! The plugin requires the Curl library. Please contact your hosting technical support or server administrator.',
        'wc_not_installed' => 'Woocommerce plugin is not installed.',
        'site_not_added' => 'The website ' . $_SERVER['HTTP_HOST'] . ' is not added in the Kommo widget settings! Go to Kommo, select "Settings" in the left menu > "Integrations," click on the widget to access its settings, and add your website in the pop-up window. For technical support, email support@crmapp.store or contact us on Telegram @bmite.',
    
        'plugin_title' => 'Woocommerce integration settings with Kommo',
        'plugin_menu_name' => 'WC Kommo',

        'status' => 'Status',
        'yes' => 'Yes',
        'no' => 'no',
        'enabled' => 'Enabled',
        'disabled' => 'Disabled',
        'not_loaded' => 'Not loaded',
        'not_selected' => 'Not selected',
        'select' => 'Select',
        'delete' => 'Delete',
        'add' => 'Add',
        'order' => 'Order',
        'save' => 'Save',
        'not_found' => 'Not found: ',
        'pipelines_not_loaded' => 'Pipelines not loaded',
        'managers_not_loaded' => 'Managers not loaded',
        'fields_not_loaded' => 'Fields not loaded',
        'integration_settings' => 'Integration settings',

        'note_default' => implode(PHP_EOL, [
            'Customer: {{billing_first_name}} {{billing_last_name}}',
            'Emai: {{billing_email}}',
            'Phone: {{billing_phone}}',
            'Billing address: {{billing_country}}, {{billing_postcode}}, {{billing_state}}, {{billing_city}}, {{billing_address_1}}, {{billing_address_2}}',
            'Shipping address: {{shipping_country}}, {{shipping_postcode}}, {{shipping_state}}, {{shipping_city}}, {{shipping_address_1}}, {{shipping_address_2}}',
            'Comment: {{customer_note}}',
        ]),
        'lead_name_default' => 'Order #{{order_id}}, {{billing_phone}}',
        'task_default' => [
            'status' => 1,
            'type' => 1,
            'text' => 'Contact the client!',
            'complete_till' => 30,
            'time' => 'minutes'
        ],
        'times' => [
            'minutes' => 'Minutes', 
            'hours' => 'Hours', 
            'days' => 'Days', 
        ],

        'payment_subscribe' => 'Pay subscription',
        'update_data' => 'Update Kommo data',
        'btn_instuction' => 'Manual',

        'main' => 'Main',
        'synchronization' => 'Synchronization',
        'custom_fields' => 'Custom fields',
        'builder' => 'Builder',
        'note' => 'Note',
        'task' => 'Task',
        'tags' => 'Tags',
        'tags_lead' => 'Tags lead',
        'tags_contact' => 'Tags contact',
        'tags_company' => 'Tags company',

        'export' => 'Export orders',
        'export_btn' => 'Export',

        'send_amocrm' => 'Send to Kommo',
        'delay_before_send' => 'Send after (sec)',
        'text_delay_before_send' => 'Set up the cron job to run every minute<br>curl -s https://'.$_SERVER['HTTP_HOST'].'/?'.self::PLUGIN_NAME.'_cron=1',

        'lead' => 'Lead',
        'lead_name' => 'Lead name',
        'responsible_list' => 'Responsible list',
        'add_products' => 'Add products to the lead',
        'add_products_note' => 'Add products to the note',       
        'duplicate_control' => 'Duplicate Control',
        'do_not_overwrite_fields' => 'Do not overwrite fields',
        'reassign_responsible' => 'Reassign responsible person',

        'pipeline' => 'Pipeline',

        'custom_fields_text' => 'Here you can add custom order fields to the "Builder" tab.',
        'last_orders' => 'Last orders',

        'order_field' => 'Order field',
        'kommo_field' => 'Kommo field',
        'order_field_value' => 'Order field value',
        'create_lead' => 'Create note in lead',
        'note_template' => 'Note Template',

        'create_task' => 'Create task in lead',
        'task_type' => 'Task type',
        'task_description' => 'Description',
        'task_deadline' => 'Deadline is in',
        
        'payment_method' => 'Payment method',
        'total' => 'Total',
        'customer' => 'Customer',
        'added' => 'Added',
        'updated' => 'Updated',
    ],
    'ru' => [
        'Name' => 'Интеграция Woocommerce с amoCRM',
        'Description' => 'Плагин позволяет настроить передачу заказов из Woocommerce в amoCRM.',

        'curl_not_installed' => 'Curl не установлен! Для работы плагина требуется библиотека Curl. Обратитесь в техническую поддержку вашего хостинга или к администратору сервера.',
        'wc_not_installed' => 'Плагин Woocommerce не установлен.',
        'site_not_added' => 'Сайт ' . $_SERVER['HTTP_HOST'] . ' не добавлен в настройках виджета amoCRM! Перейдите в amoCRM, выберите в левом меню "Настройки" > "Интеграции", нажмите на виджет для доступа к его настройкам и добавьте ваш сайт во всплывающем окне. Для технической поддержки пишите на support@crmapp.store или в Telegram @bmite.',
    
        'plugin_title' => 'Настройки интеграции Woocommerce с amoCRM',
        'plugin_menu_name' => 'WC amoCRM',

        'status' => 'Статус',
        'yes' => 'Да',
        'no' => 'Нет',
        'enabled' => 'Включено',
        'disabled' => 'Выключено',
        'not_loaded' => 'Не загружено',
        'not_selected' => 'Не выбрано',
        'select' => 'Выбрать',
        'delete' => 'Удалить',
        'add' => 'Добавить',
        'order' => 'Заказ',
        'save' => 'Сохранить',
        'not_found' => 'Не найдено: ',
        'pipelines_not_loaded' => 'Воронки не загружены',
        'managers_not_loaded' => 'Менеджеры не загружены',
        'fields_not_loaded' => 'Поля не загружены',
        'integration_settings' => 'Настройки интеграции',

        'note_default' => implode(PHP_EOL, [
            'Клиент: {{billing_first_name}} {{billing_last_name}}',
            'Email: {{billing_email}}',
            'Телефон: {{billing_phone}}',
            'Платежный адрес: {{billing_country}}, {{billing_postcode}}, {{billing_state}}, {{billing_city}}, {{billing_address_1}}, {{billing_address_2}}',
            'Адрес доставки: {{shipping_country}}, {{shipping_postcode}}, {{shipping_state}}, {{shipping_city}}, {{shipping_address_1}}, {{shipping_address_2}}',
            'Комментарий: {{customer_note}}',
        ]),
        'lead_name_default' => 'Заказ #{{order_id}}, {{billing_phone}}',
        'task_default' => [
            'status' => 1,
            'type' => 1,
            'text' => 'Связаться с клиентом!',
            'complete_till' => 30,
            'time' => 'minutes'
        ],
        'times' => [
            'minutes' => 'Минут', 
            'hours' => 'Часов', 
            'days' => 'Дней', 
        ],

        'payment_subscribe' => 'Оплатить подписку',
        'update_data' => 'Обновить данные amoCRM',
        'btn_instuction' => 'Инструкция',

        'main' => 'Основное',
        'synchronization' => 'Синхронизация',
        'custom_fields' => 'Пользовательские поля',
        'builder' => 'Конструктор',
        'note' => 'Примечание',
        'task' => 'Задача',
        'tags' => 'Теги',
        'tags_lead' => 'Теги сделки',
        'tags_contact' => 'Теги контакта',
        'tags_company' => 'Теги компании',

        'export' => 'Экспорт заказов',
        'export_btn' => 'Экспорт',

        'send_amocrm' => 'Отправить в amoCRM',
        'delay_before_send' => 'Отправить через (сек)',
        'text_delay_before_send' => 'Настроите выполнение cron-задачи каждую минуту<br>curl -s https://'.$_SERVER['HTTP_HOST'].'/?'.self::PLUGIN_NAME.'_cron=1',

        'lead' => 'Сделка',
        'lead_name' => 'Название сделки',
        'responsible_list' => 'Ответственные',
        'add_products' => 'Добавлять товары в сделку',
        'add_products_note' => 'Добавлять товары в примечание',       
        'duplicate_control' => 'Контроль дублей',
        'do_not_overwrite_fields' => 'Не перезаписывать поля',
        'reassign_responsible' => 'Переназначать ответственного',

        'pipeline' => 'Воронка',

        'custom_fields_text' => 'Здесь вы можете добавить пользовательские поля заказа во вкладку "Конструктор".',
        'last_orders' => 'Последние заказы',

        'order_field' => 'Поле заказа',
        'kommo_field' => 'Поле amoCRM',
        'order_field_value' => 'Значение поля заказа',
        'create_lead' => 'Создавать примечание в сделке',
        'note_template' => 'Шаблон примечания',

        'create_task' => 'Создавать задачу в сделке',
        'task_type' => 'Тип задачи',
        'task_description' => 'Описание',
        'task_deadline' => 'Срок выполнения',
        
        'payment_method' => 'Способ оплаты',
        'total' => 'Итого',
        'customer' => 'Клиент',
        'added' => 'Добавлено',
        'updated' => 'Обновлено',
    ],
    'pt' => [
        'Name' => 'Integração Woocommerce com Kommo',
        'Description' => 'O plugin permite configurar a transferência de pedidos do Woocommerce para o Kommo.',

        'curl_not_installed' => 'Curl não está instalado! O plugin requer a biblioteca Curl. Entre em contato com o suporte técnico de sua hospedagem ou administrador do servidor.',
        'wc_not_installed' => 'O plugin Woocommerce não está instalado.',
        'site_not_added' => 'O site ' . $_SERVER['HTTP_HOST'] . ' não foi adicionado nas configurações do widget Kommo! Acesse o Kommo, selecione "Configurações" no menu esquerdo > "Integrações", clique no widget para acessar suas configurações e adicione seu site na janela pop-up. Para suporte técnico, envie um e-mail para support@crmapp.store ou entre em contato no Telegram @bmite.',
    
        'plugin_title' => 'Configurações de integração Woocommerce com Kommo',
        'plugin_menu_name' => 'WC Kommo',

        'status' => 'Status',
        'yes' => 'Sim',
        'no' => 'Não',
        'enabled' => 'Ativado',
        'disabled' => 'Desativado',
        'not_loaded' => 'Não carregado',
        'not_selected' => 'Não selecionado',
        'select' => 'Selecionar',
        'delete' => 'Excluir',
        'add' => 'Adicionar',
        'order' => 'Pedido',
        'save' => 'Salvar',
        'not_found' => 'Não encontrado: ',
        'pipelines_not_loaded' => 'Pipelines não carregados',
        'managers_not_loaded' => 'Gerentes não carregados',
        'fields_not_loaded' => 'Campos não carregados',
        'integration_settings' => 'Configurações de integração',

        'note_default' => implode(PHP_EOL, [
            'Cliente: {{billing_first_name}} {{billing_last_name}}',
            'Email: {{billing_email}}',
            'Telefone: {{billing_phone}}',
            'Endereço de cobrança: {{billing_country}}, {{billing_postcode}}, {{billing_state}}, {{billing_city}}, {{billing_address_1}}, {{billing_address_2}}',
            'Endereço de entrega: {{shipping_country}}, {{shipping_postcode}}, {{shipping_state}}, {{shipping_city}}, {{shipping_address_1}}, {{shipping_address_2}}',
            'Comentário: {{customer_note}}',
        ]),
        'lead_name_default' => 'Pedido #{{order_id}}, {{billing_phone}}',
        'task_default' => [
            'status' => 1,
            'type' => 1,
            'text' => 'Entre em contato com o cliente!',
            'complete_till' => 30,
            'time' => 'minutes'
        ],
        'times' => [
            'minutes' => 'Minutos', 
            'hours' => 'Horas', 
            'days' => 'Dias', 
        ],

        'payment_subscribe' => 'Pagar assinatura',
        'update_data' => 'Atualizar dados do Kommo',
        'btn_instuction' => 'Manual',

        'main' => 'Principal',
        'synchronization' => 'Sincronização',
        'custom_fields' => 'Campos personalizados',
        'builder' => 'Construtor',
        'note' => 'Nota',
        'task' => 'Tarefa',
        'tags' => 'Tags',
        'tags_lead' => 'Tags de lead',
        'tags_contact' => 'Tags de contato',
        'tags_company' => 'Tags de empresa',

        'export' => 'Exportar pedidos',
        'export_btn' => 'Exportar',

        'send_amocrm' => 'Enviar para Kommo',
        'delay_before_send' => 'Enviar após (seg)',
        'text_delay_before_send' => 'Configure a tarefa cron para executar a cada minuto<br>curl -s https://'.$_SERVER['HTTP_HOST'].'/?'.self::PLUGIN_NAME.'_cron=1',

        'lead' => 'Lead',
        'lead_name' => 'Nome do lead',
        'responsible_list' => 'Lista de responsáveis',
        'add_products' => 'Adicionar produtos ao lead',
        'add_products_note' => 'Adicionar produtos à nota',       
        'duplicate_control' => 'Controle de duplicatas',
        'do_not_overwrite_fields' => 'Não sobrescrever campos',
        'reassign_responsible' => 'Reatribuir responsável',

        'pipeline' => 'Pipeline',

        'custom_fields_text' => 'Aqui você pode adicionar campos personalizados de pedido na aba "Construtor".',
        'last_orders' => 'Últimos pedidos',

        'order_field' => 'Campo do pedido',
        'kommo_field' => 'Campo do Kommo',
        'order_field_value' => 'Valor do campo do pedido',
        'create_lead' => 'Criar nota no lead',
        'note_template' => 'Modelo de nota',

        'create_task' => 'Criar tarefa no lead',
        'task_type' => 'Tipo de tarefa',
        'task_description' => 'Descrição',
        'task_deadline' => 'Prazo em',
        
        'payment_method' => 'Método de pagamento',
        'total' => 'Total',
        'customer' => 'Cliente',
        'added' => 'Adicionado',
        'updated' => 'Atualizado',
    ],
    'es' => [
        'Name' => 'Integración Woocommerce con Kommo',
        'Description' => 'El plugin permite configurar la transferencia de pedidos desde Woocommerce a Kommo.',

        'curl_not_installed' => '¡Curl no está instalado! El plugin requiere la biblioteca Curl. Contacte al soporte técnico de su hosting o al administrador del servidor.',
        'wc_not_installed' => 'El plugin Woocommerce no está instalado.',
        'site_not_added' => '¡El sitio web ' . $_SERVER['HTTP_HOST'] . ' no está añadido en la configuración del widget de Kommo! Vaya a Kommo, seleccione "Configuración" en el menú izquierdo > "Integraciones", haga clic en el widget para acceder a su configuración y añada su sitio web en la ventana emergente. Para soporte técnico, envíe un correo a support@crmapp.store o contáctenos en Telegram @bmite.',
    
        'plugin_title' => 'Configuración de integración Woocommerce con Kommo',
        'plugin_menu_name' => 'WC Kommo',

        'status' => 'Estado',
        'yes' => 'Sí',
        'no' => 'No',
        'enabled' => 'Activado',
        'disabled' => 'Desactivado',
        'not_loaded' => 'No cargado',
        'not_selected' => 'No seleccionado',
        'select' => 'Seleccionar',
        'delete' => 'Eliminar',
        'add' => 'Añadir',
        'order' => 'Pedido',
        'save' => 'Guardar',
        'not_found' => 'No encontrado: ',
        'pipelines_not_loaded' => 'Embudos no cargados',
        'managers_not_loaded' => 'Gestores no cargados',
        'fields_not_loaded' => 'Campos no cargados',
        'integration_settings' => 'Configuración de integración',

        'note_default' => implode(PHP_EOL, [
            'Cliente: {{billing_first_name}} {{billing_last_name}}',
            'Email: {{billing_email}}',
            'Teléfono: {{billing_phone}}',
            'Dirección de facturación: {{billing_country}}, {{billing_postcode}}, {{billing_state}}, {{billing_city}}, {{billing_address_1}}, {{billing_address_2}}',
            'Dirección de envío: {{shipping_country}}, {{shipping_postcode}}, {{shipping_state}}, {{shipping_city}}, {{shipping_address_1}}, {{shipping_address_2}}',
            'Comentario: {{customer_note}}',
        ]),
        'lead_name_default' => 'Pedido #{{order_id}}, {{billing_phone}}',
        'task_default' => [
            'status' => 1,
            'type' => 1,
            'text' => '¡Contacte al cliente!',
            'complete_till' => 30,
            'time' => 'minutes'
        ],
        'times' => [
            'minutes' => 'Minutos', 
            'hours' => 'Horas', 
            'days' => 'Días', 
        ],

        'payment_subscribe' => 'Pagar suscripción',
        'update_data' => 'Actualizar datos de Kommo',
        'btn_instuction' => 'Manual',

        'main' => 'Principal',
        'synchronization' => 'Sincronización',
        'custom_fields' => 'Campos personalizados',
        'builder' => 'Constructor',
        'note' => 'Nota',
        'task' => 'Tarea',
        'tags' => 'Etiquetas',
        'tags_lead' => 'Etiquetas de lead',
        'tags_contact' => 'Etiquetas de contacto',
        'tags_company' => 'Etiquetas de empresa',

        'export' => 'Exportar pedidos',
        'export_btn' => 'Exportar',

        'send_amocrm' => 'Enviar a Kommo',
        'delay_before_send' => 'Enviar después de (seg)',
        'text_delay_before_send' => 'Configura la tarea cron para que se ejecute cada minuto<br>curl -s https://'.$_SERVER['HTTP_HOST'].'/?'.self::PLUGIN_NAME.'_cron=1',

        'lead' => 'Lead',
        'lead_name' => 'Nombre del lead',
        'responsible_list' => 'Lista de responsables',
        'add_products' => 'Añadir productos al lead',
        'add_products_note' => 'Añadir productos a la nota',       
        'duplicate_control' => 'Control de duplicados',
        'do_not_overwrite_fields' => 'No sobrescribir campos',
        'reassign_responsible' => 'Reasignar responsable',

        'pipeline' => 'Embudo',

        'custom_fields_text' => 'Aquí puede añadir campos personalizados de pedido en la pestaña "Constructor".',
        'last_orders' => 'Últimos pedidos',

        'order_field' => 'Campo del pedido',
        'kommo_field' => 'Campo de Kommo',
        'order_field_value' => 'Valor del campo del pedido',
        'create_lead' => 'Crear nota en el lead',
        'note_template' => 'Plantilla de nota',

        'create_task' => 'Crear tarea en el lead',
        'task_type' => 'Tipo de tarea',
        'task_description' => 'Descripción',
        'task_deadline' => 'Plazo en',
        
        'payment_method' => 'Método de pago',
        'total' => 'Total',
        'customer' => 'Cliente',
        'added' => 'Añadido',
        'updated' => 'Actualizado',
    ]
];