<?php

class ControllerApiAmocrmIntegration extends Controller {

    public function index($route, $data) {
		$settings = $this->config->get('amocrm_integration');

		if(!isset($settings['status']) or !$settings['status']){
			return false;
		}

		if (isset($data[0]) && !empty($data[0]) and isset($data[1]) && $data[1] and $settings['status']) {

            $order_id = $data['0'];
            $order_status_id = $data['1'];
			$order_info = $this->getOrder($order_id);
			if( !$order_info['order_status_id'] and $order_status_id){
				$this->send(
					[
						'action' => 'newOrderV2', 
						'url' => $_SERVER['HTTP_HOST'], 
						'data' => $this->newOrder($order_id, $order_status_id), 
						'order_id' => $order_id
					], 
					'https://devamo.ru/opencart/ajax'
				);
            }else{
				$this->send(
					[
						'action' => 'changeAmocrm', 
						'url' => $_SERVER['HTTP_HOST'], 
						'order_id' => $order_id,
						'status_id' => $settings['oc_statuses'][$order_status_id],
					], 
					'https://devamo.ru/opencart/webhook'
				);
			}
        }
	}

	private function send($data, $server_url){
		$data['redirect'] = $server_url;
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_URL, 'https://functions.yandexcloud.net/d4ek9e15tnll0dcuakaq');
		curl_setopt($curl, CURLOPT_HEADER, false);
		curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
		$output = curl_exec($curl);
		curl_close($curl);
	}

	public function newstore($route, $data, $order_id){
		$data = [
			'action' => 'newOrderV2',
			'url' => $_SERVER['SERVER_NAME'],
			'data' => $this->newOrder($order_id),
			'order_id' => $order_id,
		];
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_URL, 'https://devamo.ru/opencart/ajax');
		curl_setopt($curl, CURLOPT_HEADER, false);
		curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 1);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
		curl_exec($curl);
		curl_close($curl);
	}

    private function newOrder($order_id, $status_id = null){
		$this->load->model('checkout/amocrm_integration');
        $order_info = $this->getOrder($order_id);
		$order_fields = array_keys($order_info);
        $settings = $this->config->get('amocrm_integration');
        $comparison = $settings['comparison'];
		$responsible_user_id = $this->get_responsible_user();

		if($status_id === null){
			$status_id = isset($settings['oc_statuses'][$order_info['order_status_id']]) ? (int)$settings['oc_statuses'][$order_info['order_status_id']] : 0;
		}else{
			$status_id = isset($settings['oc_statuses'][$status_id]) ? (int)$settings['oc_statuses'][$status_id] : 0;
		}

        $lead = [
            'pipeline_id' => (int)$settings['pipeline_id'],
            'status_id' => (int)$status_id,
            'responsible_user_id' => $responsible_user_id,
        ];

		if(isset($settings['lead_name']) and $settings['lead_name'] !== ''){
			$lead_name = $settings['lead_name'];
			foreach($order_fields as $order_field){
				if( !is_array($order_info[$order_field]) ){
					$lead_name = str_replace('{{'.$order_field.'}}', $order_info[$order_field], $lead_name);
				}
			}
			$lead['name'] = $lead_name;
		}

		if(isset($settings['tags']) and $settings['tags']){
			foreach($settings['tags'] as $tag){
				foreach($order_fields as $order_field){
					if( !is_array($order_info[$order_field]) ){
						$tag = str_replace('{{'.$order_field.'}}', $order_info[$order_field], $tag);
					}
				}
				$lead['_embedded']['tags'][] = ['name' => (string)$tag];
			}
		}
        
        if($comparison){
			$note_template = $settings['note_status'] ? $settings['note_template'] : '';
            foreach($comparison as $order_field => $amo_field){
                if($amo_field !== '0'){
                    $row = explode('-', $amo_field);
                    $entry = $row['0'];
                    $field_id = $row['1'];
                    $order_value = $order_info[$order_field];

					$field_type = 'text';
					if(isset($settings['amo_data']['field_types'][$entry][$field_id])){
						$field_type = $settings['amo_data']['field_types'][$entry][$field_id];
					}
					
					if( in_array($field_type, ['date_time', 'birthday', 'date']) ){
						$order_value = strtotime($order_value);
					}elseif( in_array($field_type, ['checkbox']) ){
						$order_value = $order_value ? true : false;
					}else{
						$order_value = (string)$order_value;
					}

                    if( in_array($field_id, ['price', 'name', 'first_name', 'last_name']) ){
                        ${$entry}[$field_id] = $order_value;
                    }else{
                        ${$entry}['custom_fields_values'][] = [
                            'field_id' => (int)$field_id,
                            'values' => [
                                [
                                    'value' => $order_value
                                ]
                            ]
                        ];
                    }      
                }

				if( isset($order_info[$order_field]) and !is_array($order_info[$order_field]) ){
					$note_template = str_replace('{{'.$order_field.'}}', $order_info[$order_field], $note_template);
				}
            }

			if(isset($order_info['totals'])){
				foreach($order_info['totals'] as $total){
					$value = number_format($total['value'], 2, '.', '');
					$note_template .= $total['title'].': '.$value.' '.$order_info['currency_code'].PHP_EOL;
				}
			}

			if($settings['note_status'] and $settings['product_link'] and $order_info['products']){
				$note_template .= PHP_EOL;
				foreach($order_info['products'] as $product){
					$note_template .= $product['name'].' x'.$product['quantity'].': https://'.$_SERVER['SERVER_NAME'].'/index.php?route=product/product&product_id='.$product['product_id'] . PHP_EOL;
				}
			}
        }

		if(isset($settings['amo_data']['utm_fields']) and $settings['amo_data']['utm_fields']){
			foreach($settings['amo_data']['utm_fields'] as $field_id => $utm){
				if ( isset($_COOKIE[$utm]) and $_COOKIE[$utm] !== '' ) {
					$lead['custom_fields_values'][] = [
						'field_id' => (int)$field_id,
						'values' => [
							[
								'value' => (string)$_COOKIE[$utm]
							]
						]
					];
					$this->model_checkout_amocrm_integration->newUtm($order_id, $utm, $_COOKIE[$utm]);
				}
			}
		}

		$tasks_data = $settings['tasks'];
		$tasks = [];
		if( $tasks_data ){
			$current_datetime = date('Y-m-d H:i:s');
			foreach($tasks_data as $task_data){
				$deadline = $task_data['deadline'] === '' ? 24 : $task_data['deadline'];
				$tasks[] = [
                    'responsible_user_id' => (int)$responsible_user_id,
                    'task_type_id' => (int)$task_data['type'],
                    'text' => (string)$task_data['text'],
                    'complete_till' => (int) strtotime( $current_datetime . ' +' . $deadline . ' ' . $task_data['time'] )
				];
			}
		}

		$products = [];
		if(isset($order_info['products']) and (int)$settings['products']){
			$products = $order_info['products'];
		}else{
			$lead['price'] = (int)round($order_info['total']);
		}

		if( isset($contact) ){
			$contact['responsible_user_id'] = $responsible_user_id;
		}else{
			$contact = [];
		}

		if( isset($company) ){
			$company['responsible_user_id'] = (int)$responsible_user_id;
		}else{
			$company = [];
		}

		$data = [
            'lead'     => isset($lead) ? $lead : [],
            'contact'  => $contact,
			'company'  => $company,
            'note'     => isset($note_template) ? $note_template : [],
            'tasks'    => $tasks,
			'products' => $products,
        ];

		if( isset($settings['antidub']) and (int)$settings['antidub'] ){
			$data['antidub'] = $settings['antidub'];
		}

        return json_encode($data);

    }

	private function getOrder($order_id){
		$this->load->model('checkout/amocrm_integration');
		$order_info = $this->model_checkout_amocrm_integration->getOrder($order_id);
		$data['order_id'] = $order_id;
		$data['store_id'] = $order_info['store_id'];
		$data['store_url'] = ($_SERVER['SERVER_NAME']);
		$data['customer'] = $order_info['customer'];
		$data['customer_id'] = $order_info['customer_id'];
		$data['customer_group_id'] = $order_info['customer_group_id'];
		$data['firstname'] = $order_info['firstname'];
		$data['lastname'] = $order_info['lastname'];
		$data['email'] = $order_info['email'];
		$data['telephone'] = $order_info['telephone'];
		$data['fax'] = $order_info['fax'];
		$data['account_custom_field'] = $order_info['custom_field'];
		$data['addresses'] = $this->model_checkout_amocrm_integration->getAddresses($order_info['customer_id']);
		$data['payment_firstname'] = $order_info['payment_firstname'];
		$data['payment_lastname'] = $order_info['payment_lastname'];
		$data['payment_company'] = $order_info['payment_company'];
		$data['payment_address_1'] = $order_info['payment_address_1'];
		$data['payment_address_2'] = $order_info['payment_address_2'];
		$data['payment_city'] = $order_info['payment_city'];
		$data['payment_postcode'] = $order_info['payment_postcode'];
		$data['payment_country_id'] = $order_info['payment_country_id'];
		$data['payment_country'] = $order_info['payment_country'];
		$data['payment_zone_id'] = $order_info['payment_zone_id'];
		$data['payment_zone'] = $order_info['payment_zone'];
		$data['payment_custom_field'] = $order_info['payment_custom_field'];
		$data['payment_method'] = $order_info['payment_method'];
		$data['payment_code'] = $order_info['payment_code'];
		$data['shipping_firstname'] = $order_info['shipping_firstname'];
		$data['shipping_lastname'] = $order_info['shipping_lastname'];
		$data['shipping_company'] = $order_info['shipping_company'];
		$data['shipping_address_1'] = $order_info['shipping_address_1'];
		$data['shipping_address_2'] = $order_info['shipping_address_2'];
		$data['shipping_city'] = $order_info['shipping_city'];
		$data['shipping_postcode'] = $order_info['shipping_postcode'];
		$data['shipping_country_id'] = $order_info['shipping_country_id'];
		$data['shipping_country'] = $order_info['shipping_country'];
		$data['shipping_zone'] = $order_info['shipping_zone'];
		$data['shipping_zone_id'] = $order_info['shipping_zone_id'];
		$data['shipping_custom_field'] = $order_info['shipping_custom_field'];
		$data['shipping_method'] = $order_info['shipping_method'];
		$data['shipping_code'] = $order_info['shipping_code'];
		$data['total'] = number_format($order_info['total'], 2, '.', '');	
		$data['products'] = array();

		$products = $this->model_checkout_amocrm_integration->getOrderProducts($order_id);

		foreach ($products as $product) {
			$data['products'][] = array(
				'product_id' => $product['product_id'],
				'name'       => $product['name'],
				'model'      => $product['model'],
				'option'     => $this->model_checkout_amocrm_integration->getOrderOptions($order_id, $product['order_product_id']),
				'quantity'   => $product['quantity'],
				'price'      => number_format($product['price'], 2, '.', ''),
				'total'      => number_format($product['total'], 2, '.', ''),
				'reward'     => $product['reward']
			);
		}

		$data['order_vouchers'] = $this->model_checkout_amocrm_integration->getOrderVouchers($order_id);
		$data['coupon'] = '';
		$data['voucher'] = '';
		$data['reward'] = '';
		$data['order_totals'] = array();

		$order_totals = $this->model_checkout_amocrm_integration->getOrderTotals($order_id);

		foreach ($order_totals as $order_total) {
			$start = strpos($order_total['title'], '(') + 1;
			$end = strrpos($order_total['title'], ')');
			if ($start && $end) {
				$data[$order_total['code']] = substr($order_total['title'], $start, $end - $start);
			}
		}

		$data['order_status_id'] = $order_info['order_status_id'];
		$data['comment'] = $order_info['comment'];
		$data['affiliate_id'] = $order_info['affiliate_id'];
		$data['affiliate'] = $order_info['affiliate_firstname'] . ' ' . $order_info['affiliate_lastname'];
		$data['currency_code'] = $order_info['currency_code'];
		$data['invoice_prefix'] = $order_info['invoice_prefix'];

		if ($order_info['invoice_no']) {
			$data['invoice_no'] = $order_info['invoice_prefix'] . $order_info['invoice_no'];
		} else {
			$data['invoice_no'] = '';
		}

		$totals = $this->model_checkout_amocrm_integration->getOrderTotals($order_id);

		foreach ($totals as $total) {
			$data['totals'][] = $total;
		}

		$data['date_added'] = $order_info['date_added'];
		$data['date_modified'] = $order_info['date_modified'];

		$simple_fields = [];
		$orderSimpleFields = $this->model_checkout_amocrm_integration->getOrderSimpleFields($order_id);
		if($orderSimpleFields){
			$keys = array_keys($orderSimpleFields);
			foreach($keys as $key){
				$simple_fields[$key] = $orderSimpleFields[$key];
			}
		}

		return array_merge($simple_fields, $data);
	}

	public function test(){
		$settings = $this->config->get('amocrm_integration');
		if(!isset($settings['responsible_user_id'])){
			return 0;
		}
		$responsible_list = $settings['responsible_user_id'];
		$settings['current_responsible'] = isset($settings['current_responsible']) ? (int)$settings['current_responsible'] : 0;
		$settings['current_responsible']++;
		$settings['current_responsible'] = isset($responsible_list[($settings['current_responsible'])]) ? $settings['current_responsible'] : 0;
		$this->load->model('checkout/amocrm_integration');
		$this->model_checkout_amocrm_integration->saveSettings($settings);
		return (int)$responsible_list[($settings['current_responsible'])];
	}

	private function get_responsible_user(){
		$settings = $this->config->get('amocrm_integration');
		if(!isset($settings['responsible_user_id'])){
			return 0;
		}
		$responsible_list = $settings['responsible_user_id'];
		$settings['current_responsible'] = isset($settings['current_responsible']) ? (int)$settings['current_responsible'] : 0;
		$settings['current_responsible']++;
		$settings['current_responsible'] = isset($responsible_list[($settings['current_responsible'])]) ? ($settings['current_responsible']) : 0;
		$this->load->model('checkout/amocrm_integration');
		$this->model_checkout_amocrm_integration->saveSettings($settings);
		return (int)$responsible_list[($settings['current_responsible'])];
	}

    public function changeOpencart() {
        $json = ['status' => 0];

        $settings = $this->config->get('amocrm_integration');
        if(!isset($settings['status']) or !$settings['status']){
            exit;
        }
        
        $notify = false;
        $oc_statuses = array_flip($settings['oc_statuses']);    	
		$order_id = $this->request->post['order_id'];
        $pipeline_status_id = $this->request->post['pipeline_status_id'];
        
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($order_id);   
               
		$order_status_id = isset($oc_statuses[$pipeline_status_id]) ? $oc_statuses[$pipeline_status_id] : 0;
       
        if(isset($settings['sync_comments']) and $settings['sync_comments']){
            $comment = $this->request->post['comment'];
        }else{
            $comment = '';
			$settings['sync_comments'] = 0;
        }
		
        $notify = false;
	
		if($order_id and $order_status_id){
            $this->load->model('checkout/order');
            $this->model_checkout_order->addOrderHistory($order_id, $order_status_id, $comment, $notify, 0);
            $json['status'] = 1;
    		
		}

		$this->response->addHeader('Access-Control-Allow-Methods: POST, OPTIONS');
		$this->response->addHeader('Access-Control-Max-Age: 1000');
		$this->response->addHeader('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}

?>