<?= $header; ?><?= $column_left; ?>
<div id="content">
    <div class="page-header">
        <div class="container-fluid">
            <div class="pull-right">
                <button type="button" data-toggle="tooltip" title="<?= $button_save; ?>" class="btn btn-success" id="save"><i class="fa fa-save"></i></button>
                <button type="submit" form="form-amocrm_integration" data-toggle="tooltip" onclick="$('form.form-horizontal').attr('action','<?= $action; ?>&refresh');" title="<?= $button_update ?>" class="btn btn-warning" id="refresh"><i class="fa fa-refresh"></i></button>
                <a href="<?= $cancel; ?>" data-toggle="tooltip" title="<?= $button_cancel; ?>" class="btn btn-default"><i class="fa fa-sign-out"></i></a>
            </div>
            <h1><?= $heading_title; ?></h1>
            <ul class="breadcrumb">
                <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                <li><a href="<?= $breadcrumb['href']; ?>"><?= $breadcrumb['text']; ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </div>
    <div class="container-fluid">
        <?php if ($error_warning) { ?>
        <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?= $error_warning; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php } ?>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-pencil"></i> <?= $text_edit; ?></h3>
            </div>
            <div class="panel-body">
                <form action="<?= $action; ?>" method="post" enctype="multipart/form-data" id="form-amocrm_integration" class="form-horizontal">

                    <ul class="nav nav-tabs">
                        <li><a href="#tab-main" data-toggle="tab"><?= $tab_main ?></a></li>
                        <li><a href="#tab-sync" data-toggle="tab"><?= $tab_sync ?></a></li>
                        <li><a href="#tab-doubles" data-toggle="tab"><?= $tab_doubles ?></a></li>
                        <li><a href="#tab-constructor" data-toggle="tab"><?= $tab_builder ?></a></li>
                        <li><a href="#tab-note" data-toggle="tab"><?= $tab_note ?></a></li>
                        <li><a href="#tab-task" data-toggle="tab"><?= $tab_tasks ?></a></li>
                        <li><a href="#tab-tags" data-toggle="tab"><?= $tab_tags ?></a></li>
                        <li><a href="#tab-export" data-toggle="tab"><?= $tab_export ?></a></li>
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane" id="tab-main">

                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="input-name"><?= $text_module_status ?></label>
                                <div class="col-sm-4">
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[status]" value="1" <?=  $status ? 'checked' : ''; ?> > <?= $text_enabled; ?></label>
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[status]" value="0" <?= !$status ? 'checked' : ''; ?> > <?= $text_disabled; ?></label>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="select-lead_name"><?= $label_lead_name ?></label>
                                <div class="col-sm-6">
                                    <input type="text" name="amocrm_integration[lead_name]" value="<?= $lead_name ?>" class="form-control">
                                </div>
                                <div class="col-sm-4 control-label text-left"></div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="select-responsible_user_id"><?= $label_responsible_list ?></label>
                                <div class="col-sm-6">
                                    <select name="amocrm_integration[responsible_user_id][]" data-placeholder="<?= $text_select ?>" id="select-responsible_user_id" class="form-control" multiple>
									<?php if($managers){ ?>
										<?php foreach($managers as $id => $manager){ ?>
											<option value="<?= $id ?>" <?= in_array($id, $responsible_user_id) ? 'selected' : ''; ?>><?= $manager ?></option>
										<?php } ?>
									<?php } ?>
                                    </select>
                                </div>
                                <div class="col-sm-4 control-label text-left"></div>
                            </div>


                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="input-notify_note"><?= $label_add_products ?></label>
                                <div class="col-sm-4">
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[products]" value="1" <?= $products ? 'checked' : ''; ?> > <?= $text_yes ?></label>
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[products]" value="0" <?= !$products ? 'checked' : ''; ?> > <?= $text_no ?></label>
                                </div>
                            </div>                         

                        </div>

                        <div class="tab-pane" id="tab-sync">
                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="select-pipeline_id"><?= $label_pipeline ?></label>
                                <div class="col-sm-2">
                                    <select name="amocrm_integration[pipeline_id]" id="select-pipeline_id" class="form-control">
									<?php if($pipelines){ ?>
										<?php foreach($pipelines as $ID => $pipeline){ ?>
											<option value="<?= $ID ?>" <?= ($ID == $pipeline_id) ? 'selected' : ''; ?>><?= $pipeline['name'] ?></option>
										<?php } ?>
									<?php } ?>
                                    </select>
                                </div>
                            </div>
                            <?php foreach($order_statuses as $oc_status){ ?>
                            <div class="form-group">                                
                                <div class="col-sm-2">
                                    <input type="text" value="<?= $oc_status['name'] ?>" readonly class="form-control">
                                </div>
                                <div class="col-sm-2">
                                    <select name="amocrm_integration[oc_statuses][<?= $oc_status['order_status_id'] ?>]" id="oc_status_<?= $oc_status['order_status_id'] ?>" class="form-control">
                                        <option value="0" selected=""><?= $text_not_selected ?></option>
                                    </select>
                                    </div>
                                </div>
                            <?php } ?>  
						</div>

                        <div class="tab-pane" id="tab-note">
                           
                            <div class="form-group">
                                <label class="col-sm-2 control-label"><?= $label_creat_note ?></label>
                                <div class="col-sm-2">
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[note_status]" value="1" <?=  $note_status ? 'checked' : ''; ?> > <?= $text_yes ?></label>
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[note_status]" value="0" <?= !$note_status ? 'checked' : ''; ?> > <?= $text_no ?></label>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="input-name"><?= $text_add_link_products ?></label>
                                <div class="col-sm-4">
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[product_link]" value="1" <?= $product_link ? 'checked' : ''; ?> > <?= $text_yes ?></label>
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[product_link]" value="0" <?= !$product_link ? 'checked' : ''; ?> > <?= $text_no ?></label>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label"><?= $text_note_template ?></label>
                                <div class="col-sm-4">
                                    <textarea id="note_template" name="amocrm_integration[note_template]" rows="15" class="form-control"><?= $note_template ?></textarea>
                                </div>

                                <div class="col-sm-6">
                                    <div class="control-label text-left"><strong><?= $text_order_field ?></strong></div>
                                    <div class="order_tags">
                                        <span class="btn-xs btn-outline-primary"><?= implode('</span>, <span class="btn-xs btn-outline-primary">', $order_fields) ?></span>
                                    </div>
                                </div>

                            </div>

                        </div>

                        <div class="tab-pane" id="tab-task">

                            <div class="form-group">

                                <div class="task_titles">
                                    <label class="col-sm-2 control-label text-left"><?= $text_task_type ?></label>
                                    <label class="col-sm-3 control-label text-left"><?= $text_description ?></label>
                                    <label class="col-sm-2 control-label text-left"><?= $text_deadline ?></label>
                                    <label class="col-sm-2 control-label text-left">&nbsp;</label>
                                    <label class="col-sm-1 control-label text-left"></label>
                                </div>
                                <div class="clearfix"></div>
                                <hr>

                                <div class="tasks col-sm-12">

                                    <?php if($tasks){ ?>
                                        <?php foreach($tasks as $task_id => $task){ ?>
                                        <div id="task_<?= $task_id ?>" class="form-group task">
                                            <div class="col-sm-2">
                                                <select name="amocrm_integration[tasks][<?= $task_id ?>][type]" id="select-task_type" class="form-control">
                                                <?php if($task_types){ ?>
                                                    <?php foreach($task_types as $tasktype){ ?>
                                                    <option value="<?= $tasktype['id'] ?>" <?= $tasktype['id'] == $task['type'] ? 'selected' : ''; ?>><?= $tasktype['name'] ?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                                </select>
                                            </div>

                                            <div class="col-sm-3">
                                                <input name="amocrm_integration[tasks][<?= $task_id ?>][text]" value="<?= $task['text'] ?>" class="form-control">
                                            </div>

                                            <div class="col-sm-2">
                                                <input name="amocrm_integration[tasks][<?= $task_id ?>][deadline]" value="<?= $task['deadline'] ?>" class="form-control">
                                            </div>

                                            <div class="col-sm-2">
                                                <select name="amocrm_integration[tasks][<?= $task_id ?>][time]" id="select-task_time" class="form-control">
                                                    <?php foreach($task_times as $task_time_value => $task_time_name){ ?>
                                                    <option value="<?= $task_time_value ?>" <?= $task_time_value == $task['time'] ? 'selected' : '' ?>><?= $task_time_name ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                            
                                            <div class="col-sm-1"><button type="button" onclick="$('#task_<?= $task_id ?>').remove();" data-toggle="tooltip" title="" class="btn btn-danger" data-original-title="<?= $text_delete ?>"><i class="fa fa-minus-circle"></i></button></div>

                                        </div>
                                        <?php } ?>
                                    <?php } ?>

                                </div>

                                <div class="clearfix"></div>

                                <div class="col-sm-1 col-sm-offset-9">
                                    <button type="button" id="newTask" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button>
                                </div>

                            </div>
                        </div>


                        <div class="tab-pane" id="tab-doubles">

                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="input-antidub_status"><?= $text_status ?></label>
                                <div class="col-sm-4">
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[antidub][status]" value="1" <?= ($antidub_status) ? 'checked' : '' ?> > <?= $text_enabled ?></label>
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[antidub][status]" value="0" <?= ($antidub_status) ? '' : 'checked' ?> > <?= $text_disabled ?></label>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="select-antidub_ignore"><?= $text_do_not_overwrite_fields ?></label>
                                <div class="col-sm-6">
                                    <select name="amocrm_integration[antidub][ignore][]" data-placeholder="<?= $text_select ?>" id="select-antidub_ignore" multiple class="form-control">
                                        <?php if ($antidub_ignore){ ?>
                                            <?php foreach ($antidub_ignore as $id => $field){ ?>
                                                <option value="<?= $id ?>" <?= in_array($id, $ignore) ? 'selected' : '' ?>>
                                                    <?= htmlspecialchars($field) ?>
                                                </option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="select-change_responsible"><?= $text_reassign_responsible ?></label>
                                <div class="col-sm-2">
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[antidub][change_responsible]" value="1" <?= ($change_responsible ? 'checked' : '') ?> ><?= $text_yes ?></label>
                                    <label class="radio-inline"><input type="radio" name="amocrm_integration[antidub][change_responsible]" value="0" <?= ($change_responsible ? '' : 'checked') ?> ><?= $text_no ?></label>
                                </div>
                                <div class="col-sm-8 control-label text-left">
                                </div>
                            </div>
                            
                        </div>


                        <div class="tab-pane" id="tab-constructor">

                            <div class="form-group">
                                <label class="col-sm-2 control-label" for="select-order"><?= $text_last_orders ?></label>
                                <div class="col-sm-2">
                                    <select name="orders" id="select-order" class="form-control">
                                        <?php foreach($orders as $ID => $order){ ?>
                                            <option value="<?= $order['order_id'] ?>"><?= $text_order ?> #<?= $order['order_id'] ?> (<?= $order['customer'] ?>)</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
						
                            <div class="form-group">
                                <label class="col-sm-2 control-label"><?= $text_order_field ?></label>
                                <label class="col-sm-2 control-label text-left"><?= $text_amocrm_field ?></label>
                                <label class="col-sm-2 control-label text-left"><?= $text_order_field_value ?></label>
                            </div>

							<?php if($order_fields){ ?>

								<?php foreach($order_fields as $order_field){ ?>
								<div class="form-group">
									<label class="col-sm-2 control-label" for="select-<?= $order_field ?>"><?= $order_field; ?></label>
									<div class="col-sm-2">
										<select name="amocrm_integration[comparison][<?= $order_field ?>]" id="select-<?= $order_field ?>" class="form-control">
											<option value="0">Не выбрано</option>
											<?php if($fields){ ?>
												<?php foreach($fields as $ID => $field){ ?>
													<option value="<?= $ID ?>" <?= (isset($comparison[$order_field]) and $comparison[$order_field] === $ID) ? 'selected' : '' ?> ><?= $field ?></option>
												<?php } ?>
											<?php } ?>
										</select>	
									</div>
									<label class="col-sm-2 control-label text-left" for="select-<?= $order_field ?>" id="order_field_<?= $order_field ?>"></label>
								</div>
								<?php } ?>
							
							<?php } ?>
						</div>

                        <div class="tab-pane" id="tab-tags">
                            <label class="col-sm-8 control-label text-left font-weight-400"><?= $text_tag_description ?></label>
                            <div class="clearfix"></div>
                            <hr
                            >
                            <div id="tags_row">
                                <?php if($tags) { ?>
                                    <?php foreach ($tags as $tag) { ?>
                                        <div class="menu_tag">
                                            <div class="col-sm-2">
                                                <input type="text" name="amocrm_integration[tags][]" value="<?= $tag ?>" class="form-control" />
                                            </div>
                                            <div class="col-sm-1"><button type="button" onclick="$(this).parent().parent().remove();" data-toggle="tooltip" title="" class="btn btn-danger" data-original-title="<?= $text_delete ?>"><i class="fa fa-minus-circle"></i></button></div>
                                        </div>
                                    <?php } ?>
                                <?php } ?>
                            </div>
							<div class="col-sm-1 col-sm-offset-2"><button type="button" onclick="addRowTag();" data-toggle="tooltip" title="" class="btn btn-primary" data-original-title="<?= $text_add ?>"><i class="fa fa-plus-circle"></i></button></div>
                        </div>

                        <div class="tab-pane" id="tab-export">

                            <div class="table-responsive">
                                <table class="table table-bordered table-hover order">
                                    <thead>
                                    <tr>
                                        <td style="width: 1px;" class="text-center">
                                            <input type="checkbox" onclick="$('input[name^=orders]').prop('checked', this.checked);">
                                        </td>
                                        <td class="text-right"><?= $text_order ?> #</td>
                                        <td class="text-left"><?= $text_client ?></td>
                                        <td class="text-left"><?= $text_status ?></td>
                                        <td class="text-right"><?= $text_total ?></td>
                                        <td class="text-left"><?= $text_added ?></td>
                                        <td class="text-left"><?= $text_updated ?></td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        <?php if($orders){ ?>
                                            <?php foreach($orders as $order){ ?>
                                            <tr>
                                                <td class="text-center">
                                                    <input type="checkbox" name="orders[]" value="<?= $order['order_id'] ?>">
                                                </td>
                                                <td class="text-right"><?= $order['order_id'] ?></td>
                                                <td class="text-left"><?= $order['customer'] ?></td>
                                                <td class="text-left"><?= $order['order_status'] ?></td>
                                                <td class="text-right"><?= ceil($order['total']) ?> <?= $order['currency_code'] ?></td>
                                                <td class="text-left"><?= date('d.m.Y H:i:s', strtotime($order['date_added'])) ?></td>
                                                <td class="text-left"><?= date('d.m.Y H:i:s', strtotime($order['date_modified'])) ?></td>
                                            </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                </table>

                                <div class="pagination">
                                    <div class="text-left"><?= $pagination; ?></div>
                                    <div class="text-right"><?= $results; ?></div>
                                </div>
                                
                                <div class="progress-container">
                                    <div class="col-sm-10">
                                        <div class="progress">
                                            <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="min-width: 2em; width: 0%;">0%</div>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 text-right">
                                        <button type="button" id="export" class="btn btn-primary"><?= $text_export ?></button>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
<!--
$(document).on('click', '.pagination a', function(e){
    e.stopPropagation();
    e.preventDefault();
    var href = $(this).attr('href');
    $('#tab-export').load(href + ' #tab-export>*');
});

$('#save').on('click', function(){
    var tab = $('.tab-content .tab-pane.active').attr('id');
    var action = '<?= $action; ?>&apply&tab=' + tab;
    $('form.form-horizontal').attr('action', action).submit();
});

$('#refresh').on('click', function(){
    var tab = $('.tab-content .tab-pane.active').attr('id');
    var action = '<?= $action; ?>&refresh&tab=' + tab;
    $('form.form-horizontal').attr('action', action).submit();
});

$('.nav-tabs a[href=#<?= $tab ?>]').parent().addClass('active');
$('#<?= $tab ?>').addClass('active');


var last_task_id = 0;
$(document).on('click', '#newTask', function(){
    last_task_id++;
    var task = '<div id="task_'+last_task_id+'" class="form-group task">';
            task += '<div class="col-sm-2">';
                task += '<select name="amocrm_integration[tasks]['+last_task_id+'][type]" id="select-task_type" class="form-control">';
                <?php if($task_types){ ?>
                    <?php foreach($task_types as $tasktype){ ?>
                    task += '<option value="<?= $tasktype['id'] ?>"><?= $tasktype['name'] ?></option>';
                    <?php } ?>
                <?php } ?>
                task += '</select>';
            task += '</div>';

            task += '<div class="col-sm-3">';
                task += '<input name="amocrm_integration[tasks]['+last_task_id+'][text]" value="<?= $text_task_description ?>" class="form-control">';
            task += '</div>';

            task += '<div class="col-sm-2">';
                task += '<input name="amocrm_integration[tasks]['+last_task_id+'][deadline]" value="24" class="form-control">';
            task += '</div>';

            task += '<div class="col-sm-2">';
                task += '<select name="amocrm_integration[tasks]['+last_task_id+'][time]" id="select-task_time" class="form-control">';
                    <?php foreach($task_times as $task_time_value => $task_time_name){ ?>
                    task += '<option value="<?= $task_time_value ?>" <?= $task_time_value == 'hours' ? 'selected' : '' ?>><?= $task_time_name ?></option>';
                    <?php } ?>
                task += '</select>';
            task += '</div>';
            task += '<div class="col-sm-1"><button type="button" data-toggle="tooltip" title="" class="btn btn-danger btn-delete_task" data-original-title="<?= $text_delete ?>"><i class="fa fa-minus-circle"></i></button></div>';
        task += '</div>';
    $('.tasks').append(task);
    $('#task_'+last_task_id+' select').chosen({
        disable_search_threshold: 10,
        width: '100%',
        allow_single_deselect: true,
        no_results_text: '<?= $text_no_results ?>'
    });
});

$('.tasks').on('click', '.btn-delete_task', function(){
    $(this).parents('.task').remove();
});

$(document).on('click', '#export', function(){
    var orders = $('.order input[type=checkbox]:checked');
    $('.tab-content .progress-bar').css('width', '0%').text('0%');
    if(orders.length){
        $.ajax({
            url : '/admin/index.php?route=extension/module/amocrm_integration/export&token=<?= $token ?>',
            type: 'post',
            data: $('.order input[type=checkbox]:checked'),
            dataType: 'json',
            success: function(data) {
                if(data.length){
                    $('.tab-content .progress-bar').css('width', '100%').text('100%');
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }else{
        $('.tab-content .progress-bar').css('width', '0%').text('0%');
    }


});

var order_fields = <?= json_encode($order_fields) ?>;
var pipelines = <?= json_encode($pipelines); ?>;
var pipeline_id = <?= $pipeline_id; ?>;
var order_statuses = <?= json_encode($order_statuses) ?>;
var oc_statuses = <?= json_encode($oc_statuses) ?>;

changePipeline(pipeline_id);

$('#select-pipeline_id').on('change', function(){
    var pipeline_id = $(this).val(); 
    changePipeline(pipeline_id);
});

function changePipeline(pipeline_id = false){
    var options = '<option value="0"><?= $text_not_selected ?></option>';
    if( pipeline_id == 0 || !pipeline_id ){
        $('#select-amo_status').html(options).trigger("chosen:updated");;
        return false;
    }

    $.each(pipelines[pipeline_id]['statuses'], function(status_id, value) {
        options += '<option value="'+status_id+'">'+value.name+'</option>'
    }); 

    $.each(order_statuses, function(index, status){
        $('#oc_status_'+status.order_status_id).html(options);
        if(status.order_status_id in oc_statuses && oc_statuses[status.order_status_id] !== '' ){
            $('#oc_status_'+status.order_status_id+' option[value='+oc_statuses[status.order_status_id]+']').attr('selected', 'selected');
        }
        $('#oc_status_'+status.order_status_id).trigger("chosen:updated");
    }); 
}

$('.amocrm-integration .settings input[type=checkbox]').on('change', function(){
    $('#publishing-action input[type=submit]').click();
});

$(document).on('change', '#select-order', function(){
    var order_id = $(this).val();
    order_reload(order_id);
});

function order_reload(order_id){
    var data = [];
    data.push({name: "order_id", value: order_id});
    $.ajax({
        url : '/admin/index.php?route=extension/module/amocrm_integration/order&token=<?= $token ?>',
        type: 'POST',
        dataType: 'json',
        data: data,
        success:function(data){
            if(data.status){
                $('label[id^=order_field_]').text('');
                $.each(order_fields, function(index, order_field){
                    $('#order_field_'+order_field).text(data.order[order_field]);
                });
            }else{
                var error = '<span style="color:red">'+data.message+'</span>';
                $('#result').html(error);
            }
        }
    });
}

if( $('#select-order').val() > 0 ){
    order_reload( $('#select-order').val() );
}

$(document).on('click', '.order_tags span', function(){
    var oldValue = $('#note_template').val();
    $('#note_template').val( oldValue + '{{' + $(this).text() + '}}' );
});

function addRowTag() {
        html = '<div class="menu_tag">';
        html += '   <div class="col-sm-2">';
        html += '       <input type="text" name="amocrm_integration[tags][]" value="" class="form-control">';
        html += '   </div>';
        html += '   <div class="col-sm-1"><button type="button" onclick="$(this).parent().parent().remove();" data-toggle="tooltip" title="" class="btn btn-danger" data-original-title="<?= $text_delete ?>"><i class="fa fa-minus-circle"></i></button></div>';
        html += '</div>';
    $('#tags_row').append(html);    
}

$('select').chosen({
    disable_search_threshold: 10,
    width: '100%',
    allow_single_deselect: true,
    no_results_text: '<?= $text_no_results ?>'
});
//
-->
</script>

<?= $footer; ?>
