<?php 

function customFormsComplete_forms_amocrm( $form_id, $post ) {   
    $form_fields = get_post_meta( $form_id, 'customforms-amocrm', 1 );
    
    if( isset($form_fields['status']) and $form_fields['status'] ){
        $settings = get_option('customforms-amocrm');
        date_default_timezone_set('UTC');
        $entities = [];
        $options = get_option('customforms-amocrm-settings');
        $field_types = $options['field_types'];
        $utms = isset($options['utm_fields']) ? $options['utm_fields'] : false;
        $responsible_user_id = (int)$form_fields['responsible_user_id'];
        $lead_name = $form_fields['lead_name'];
        $note = $form_fields['note'];
        $task_text = $form_fields['task']['task_text'];
        
        if( isset($post[$form_fields['post_ID']]) ){
            $post_id = $post[$form_fields['post_ID']];
            $page_name = get_the_title($post_id);
            $page_url = get_option('home').'?p='.$post_id;
        }

        $required = isset($form_fields['required']) ? $form_fields['required'] : [];

        // проверим на заполнение обязательные поля
        if($required){
            foreach($required as $key => $req){
                if( !isset($post[$req]) or $post[$req] !== '' ){
                    unset($required[$key]);
                }
            }
        }

        $current_datetime = date('Y-m-d H:i:s');
        $form_name = get_the_title($form_id);
        $home_url = get_option('home');
        require (__DIR__ . '/fields_default.php');


        $ip = getIp_forms_amocrm();
        $userAgent = $_SERVER['HTTP_USER_AGENT'];
        $os = getOS_forms_amocrm($userAgent);
        $browser = getBrowser_forms_amocrm($userAgent);       

        foreach($custom_tags as $custom_tag => $custom_tag_name){
            $lead_name = str_replace('{{'.$custom_tag.'}}', ${$custom_tag}, $lead_name);
            $note = str_replace('{{'.$custom_tag.'}}', ${$custom_tag}, $note);
            $custom_tag_value = $form_fields['custom_tags'][$custom_tag]; // !!!!!!!!!
    
            if($custom_tag_value !== '0' and $custom_tag_value !== ''){
                $_data = explode('-', $custom_tag_value);
                $entity = $_data['0'];
                if( $entity === '' or $entity === null ){
                    continue;
                }
                $field_id = $_data['1'];
                $field_type = 'text';
                if(isset($field_types[$entity][$field_id])){
                    $field_type = $field_types[$entity][$field_id];
                }
    
                if( in_array($field_type, ['date_time', 'birthday', 'date']) ){
                    $form_value = strtotime(${$custom_tag});
                }elseif( in_array($field_type, ['checkbox']) ){
                    $form_value = ${$custom_tag} ? true : false;
                }else{
                    $form_value = (string)${$custom_tag};
                }
    
                if($form_value === '' or $form_value === null){
                    continue;
                }
                
                if($field_id === 'price'){
                    $form_value = (int)$form_value;
                }
    
                if( in_array($field_id, ['price', 'name', 'first_name', 'last_name']) ){
                    $entities[$entity][$field_id] = $form_value;
                }else{
    
                    if(is_array(${$custom_tag})){
                        $values = [];
                        foreach(${$custom_tag} as $fv){
                            $values[] = ['value' => $fv];
                        }
                        $entities[$entity]['custom_fields_values'][] = [
                            'field_id' => (int)$field_id,
                            'values' => $values
                        ];
                    }else{
                        $entities[$entity]['custom_fields_values'][] = [
                            'field_id' => (int)$field_id,
                            'values' => [
                                [
                                    'value' => $form_value
                                ]
                            ]
                        ];
                    }
                }
            }
        }
        
        foreach($post as $form_field => $form_field_value){
            $key = isset($form_fields['fields'][$form_field]) ? $form_fields['fields'][$form_field] : false;
            if($key !== '0' and $key !== ''){
                $_data = explode('-', $key);
                $entity = $_data['0'];
                if( $entity === '' or $entity === null ){
                    continue;
                }
                $field_id = $_data['1'];
    
                $field_type = 'text';
    
                if(isset($field_types[$entity][$field_id])){
                    $field_type = $field_types[$entity][$field_id];
                }
    
                if( in_array($field_type, ['date_time', 'birthday', 'date']) ){
                    $form_value = strtotime($form_field_value);
                }elseif( in_array($field_type, ['checkbox']) ){
                    $form_value = $form_field_value ? true : false;
                }else{
                    $form_value = (string)$form_field_value;
                }
    
                if($form_value === '' or $form_value === null){
                    continue;
                }

                if($field_id === 'price'){
                    $form_value = (int)$form_value;
                }
    
                if( in_array($field_id, ['price', 'name', 'first_name', 'last_name']) ){
                    $entities[$entity][$field_id] = $form_value;
                }else{
                    if( in_array($field_type, ['checkbox']) ){
                        $entities[$entity]['custom_fields_values'][] = [
                            'field_id' => (int)$field_id,
                            'values' => [
                                [
                                    'value' => $form_value
                                ]
                            ]
                        ];
                    }elseif(is_array($form_field_value)){
                        $values = [];
                        foreach($form_field_value as $fv){
                            $values[] = ['value' => $fv];
                        }
                        $entities[$entity]['custom_fields_values'][] = [
                            'field_id' => (int)$field_id,
                            'values' => $values
                        ];
                    }else{
                        $entities[$entity]['custom_fields_values'][] = [
                            'field_id' => (int)$field_id,
                            'values' => [
                                [
                                    'value' => $form_value
                                ]
                            ]
                        ];
                    }
                }
            }

            if(is_array($form_field_value)){
                $form_field_value = implode(', ', $form_field_value);
            }

            if( is_string($form_field_value)){
                $note = str_replace('{{'.$form_field.'}}', $form_field_value, $note);
                $lead_name = str_replace('{{'.$form_field.'}}', $form_field_value, $lead_name);     
                $task_text = str_replace('{{'.$form_field.'}}', $form_field_value, $task_text);

                if($form_fields['tags']){
                    foreach($form_fields['tags'] as $key => $tag){
                        $form_fields['tags'][$key] = str_replace('{{'.$form_field.'}}', $form_field_value, $tag);
                    }
                }
            }

 
        }
    
        if($utms){
            foreach($utms as $field_id => $utm){
                if (isset($_COOKIE[$utm])) {
                    $entities['lead']['custom_fields_values'][] = [
                        'field_id' => (int)$field_id,
                        'values' => [
                            [
                                'value' => (string)$_COOKIE[$utm]
                            ]
                        ]
                    ];
                }
            }
        }

        $entities['task'] = [];
        if( $form_fields['task']['task_status'] == 1 ){
            $task_type = $form_fields['task']['task_type'];
            
            foreach($custom_tags as $custom_tag => $custom_tag_name){
                $task_text = str_replace('{{'.$custom_tag.'}}', ${$custom_tag}, $task_text);
            }

            $task_complete_till = $form_fields['task']['task_complete_till'];
            $task_complete_till_times = $form_fields['task']['task_complete_till_times'];
            
            $task_complete_till = strtotime($current_datetime . ' +' . $task_complete_till . ' ' . $task_complete_till_times );
            $entities['task'] = [
                'responsible_user_id' => (int)$responsible_user_id,
                'task_type_id' => (int)$task_type,
                'text' => $task_text,
                'complete_till' => strtotime($current_datetime),
                'duration' => $task_complete_till - strtotime($current_datetime),
            ];
        }

        $pipeline_id = (int)$form_fields['pipeline_id'];
        $p_status = $form_fields['p_status'];
        $price = (int)$form_fields['price'];

        $entities['lead']['name'] = $lead_name;

        $unsortered = strpos($p_status, 'unsortered_');
   
        if($pipeline_id){
            $entities['lead']['pipeline_id'] = $pipeline_id;
        }

        // если разобранное
        $entities['lead']['status_id'] = (int)$p_status;
        $entities['lead']['pipeline_id'] = $pipeline_id;       
        $entities['lead']['responsible_user_id'] = (int)$responsible_user_id;

        if($price){
            $entities['lead']['price'] = (int)$price;
        }

        if($form_fields['tags']){
            foreach($form_fields['tags'] as $tag){
                if(empty($tag)){
                    continue;
                }
                foreach($custom_tags as $custom_tag => $custom_tag_name){
                    $tag = str_replace('{{'.$custom_tag.'}}', ${$custom_tag}, $tag);
                }
                $entities['lead']['tags_to_add'][] = ['name' => (string)$tag];
            }
        }

        if(isset($entities['contact'])){
            $entities['contact']['responsible_user_id'] = (int)$responsible_user_id;
        }

        if(isset($entities['company'])){
            $entities['company']['responsible_user_id'] = (int)$responsible_user_id;
        }

        $entities['note'] = $note;
        $entities['ip'] = $ip;

        if(isset($form_fields['salesbot']) and (int)$form_fields['salesbot']['status'] and (int)$form_fields['salesbot']['id']){
            $entities['salesbot'] = $form_fields['salesbot']['id'];
        }

        // неразобранное
        if($unsortered !== false){
            $entities['lead']['request_id'] = (string)time();
            $entities['lead']['source_name'] = get_option('blogname');
            $entities['lead']['source_uid'] = md5(microtime(true).'devamo.ru');
            $entities['lead']['_embedded']['metadata'] = [ 
                'ip' => $ip,
                'form_id' => $form_id,
                'form_sent_at' => (int)time(),
                'form_name' => $form_name,
                'form_page' => ($page_url ? $page_url : $home_url),
                'referer' => $_SERVER['HTTP_REFERER'],
                'category' => 'forms',
            ];
        }
        
        if($required){
            return $required;
        }

        $data['action'] = 'CFV1';      
        $data['data'] = json_encode($entities);      
        $data['redirect'] = 'https://devamo.ru/customforms/ajax';
        $data['url'] = $_SERVER['HTTP_HOST'];

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_URL, 'https://proxy.bmite.workers.dev');
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
        $output = curl_exec($curl);

        new_forms_amocrm_lead($form_id, $entityes, true);
        return $required;
    }
}

function getIp_forms_amocrm(){
    $client  = isset($_SERVER['HTTP_CLIENT_IP']) ? $_SERVER['HTTP_CLIENT_IP'] : false;
    $forward = isset($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : false;
    $remote  = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : $_SERVER['REMOTE_ADDR'];
    if(filter_var($client, FILTER_VALIDATE_IP)){
        $ip = $client;
    }elseif(filter_var($forward, FILTER_VALIDATE_IP)){
        $ip = $forward;
    }else{
        $ip = $remote;
    }
    return $ip;
}

function getOS_forms_amocrm($userAgent) { 
    $os_platform  = "Unknown OS Platform";
    $os_array     =  [
        '/windows nt 10/i'      =>  'Windows 10',
        '/windows nt 6.3/i'     =>  'Windows 8.1',
        '/windows nt 6.2/i'     =>  'Windows 8',
        '/windows nt 6.1/i'     =>  'Windows 7',
        '/windows nt 6.0/i'     =>  'Windows Vista',
        '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
        '/windows nt 5.1/i'     =>  'Windows XP',
        '/windows xp/i'         =>  'Windows XP',
        '/windows nt 5.0/i'     =>  'Windows 2000',
        '/windows me/i'         =>  'Windows ME',
        '/win98/i'              =>  'Windows 98',
        '/win95/i'              =>  'Windows 95',
        '/win16/i'              =>  'Windows 3.11',
        '/macintosh|mac os x/i' =>  'Mac OS X',
        '/mac_powerpc/i'        =>  'Mac OS 9',
        '/linux/i'              =>  'Linux',
        '/ubuntu/i'             =>  'Ubuntu',
        '/iphone/i'             =>  'iPhone',
        '/ipod/i'               =>  'iPod',
        '/ipad/i'               =>  'iPad',
        '/android/i'            =>  'Android',
        '/blackberry/i'         =>  'BlackBerry',
        '/webos/i'              =>  'Mobile'
    ];
    foreach ($os_array as $regex => $value){
        if (preg_match($regex, $userAgent)){
            $os_platform = $value;
        }
    }
    return $os_platform;
}

function getBrowser_forms_amocrm($userAgent) {
      $browsers = [
        'Firefox',
        'Opera',
        'Chrome',
        'MSIE',
        'Safari'
      ];
      foreach($browsers as $browser){
          if(strpos($userAgent, $browser) !== false) { 
              return $browser;
          }
      }
      return 'Неизвестный'; // Хрен его знает, чего у него на десктопе стоит.
  }

// сохраняет отправленные заявки
function new_forms_amocrm_lead($form_id, $data){
    $form = get_post($form_id, 'ARRAY_A');
    $comment_count = $form['comment_count'];
    $comment_count++;
    $amo_settings = get_option('customforms-amocrm-settings');
    $text = [];
    foreach($data as $entity => $entity_value){
    
        $entity_keys = is_array($entity_value) ? array_keys($entity_value) : false;
        if($entity_keys){
            foreach($entity_keys as $entity_key){

                $value = $entity_value[$entity_key];
                $pipeline_id = isset($data[$entity]['pipeline_id']) ? $data[$entity]['pipeline_id'] : false;

                if( in_array($entity, ['lead', 'contact']) ){
                    switch ($entity_key) {
                        case 'name':
                            if($entity === 'lead'){
                                $name = __( 'Lead name', 'customforms-amocrm' );
                            }elseif($entity === 'contact'){
                                $name = __( 'Contact name', 'customforms-amocrm' );
                            }
                            $text[$entity][0] = $name.': '.$value;
                            break;
                        case 'responsible_user_id':
                            $text[$entity][3] = __( 'Responsible', 'customforms-amocrm' ).': '.$amo_settings['managers'][$value];
                            break;
                        case 'pipeline_id':
                            $text[$entity][1] = __( 'Pipeline', 'customforms-amocrm' ).': '.$amo_settings['pipelines'][$pipeline_id]['name'];
                            break;
                        case 'status_id':
                            $text[$entity][2] = __( 'Pipeline status', 'customforms-amocrm' ).': '.$amo_settings['pipelines'][$pipeline_id]['statuses'][$value]['name'];
                            break;
                        case 'price':
                            $text[$entity][4] = __( 'Price', 'customforms-amocrm' ).': '.$value;
                            break;
                        case 'first_name':
                            $text[$entity][0] = __( 'First name', 'customforms-amocrm' ).': '.$value;
                            break;
                        case 'last_name':
                            $text[$entity][1] = __( 'Last name', 'customforms-amocrm' ).': '.$value;
                            break;
                        case '_embedded':
                            if(isset($data['lead']['_embedded'])){
                                $tags = [];
                                foreach($data['lead']['_embedded']['tags'] as $tag){
                                    $tags[] = $tag['name'];
                                }
                                $text[$entity][99] = 'Теги: '.implode(', ', $tags);
                            }
                            break;
                        case 'custom_fields_values':
                            $fields = isset($data[$entity]['custom_fields_values']) ? $data['lead']['custom_fields_values'] : false;
                            if($fields){
                                $i = 10;
                                foreach($fields as $field){
                                    $field_name = false;
                                    $i++;
                                    if(isset($amo_settings['fields'][$entity.'-'.$field['field_id']])){
                                        $field_name = $amo_settings['fields'][$entity.'-'.$field['field_id']];
                                        $field_name =  str_replace(['Контакт :: ', 'Сделка :: '], '', $field_name);
                                        if($field['values']){
                                            $field_values = [];
                                            foreach($field['values'] as $field_value){
                                                $field_values[] = $field_value['value'];
                                            }
                                            $text[$entity][$i] = $field_name.': '.implode(', ', $field_values);
                                        }
                                    }
        
                                    if(isset($amo_settings['utm_fields'][$field['field_id']])){
                                        $field_name = $amo_settings['utm_fields'][$field['field_id']];
                                        if($field['values']){
                                            $field_values = [];
                                            foreach($field['values'] as $field_value){
                                                $field_values[] = $field_value['value'];
                                            }
                                            $text[$entity][$i] = $field_name.': '.implode(', ', $field_values);
                                        }
                                    }
        
                                }
                            }
                            break;
                    }
                    }
                    
                    if($entity === 'task'){
                        $task = $data['task'];
                        switch ($entity_key) {
                            case 'responsible_user_id':
                                if( isset($amo_settings['managers'][$task['responsible_user_id']]) ){
                                    $text[$entity][3] = __( 'Responsible', 'customforms-amocrm' ).': '.$amo_settings['managers'][$task['responsible_user_id']];
                                }
                                break;
                            case 'text':
                                $text[$entity][0] = __( 'Descriptio', 'customforms-amocrm' ).': '.$task['text'];
                                break;
                            case 'complete_till':
                                $text[$entity][1] = __( 'Deadline', 'customforms-amocrm' ).': '.date('d.m.Y H:i:s', $task['complete_till']);
                                break;
                            case 'task_type_id':
                                $task_type_name = '';
                                foreach($amo_settings['task_types'] as $task_type){
                                    if($task['task_type_id'] == $task_type['id']){
                                        $text[$entity][2] = __( 'Type', 'customforms-amocrm' ).': '.$task_type['name'];
                                    }
                                }
                                break;
                        }
                    }
                }
        }

        if($entity === 'note'){
            $text[$entity] = $entity_value;
        }           
        
    }

    $print = '';

    if(isset($text['lead'])){
        ksort($text['lead']);
        $print .= '<div>';
        $print .= '<div><b>'.__( 'Lead', 'customforms-amocrm' ).'</b></div>';
        $print .= '<p>'.implode('</p><p>', $text['lead']).'</p>';
        $print .= '</div><br>';
    }

    if(isset($text['note'])){
        $print .= '<div>';
        $print .= '<div><b>'.__( 'Note', 'customforms-amocrm' ).'</b></div>';
        $print .= '<p>' . str_replace(PHP_EOL, '</p><p>', $text['note']) . '</p>';
        $print .= '</div><br>';
    }

    if(isset($text['contact'])){
        ksort($text['contact']);
        $print .= '<div>';
        $print .= '<div><b>'.__( 'Contact', 'customforms-amocrm' ).'</b></div>';
        $print .= '<p>'.implode('</p><p>', $text['contact']).'</p>';
        $print .= '</div><br>';
    }

    if(isset($text['task'])){
        ksort($text['task']);
        $print .= '<div>';
        $print .= '<div><b>'.__( 'Task', 'customforms-amocrm' ).'</b></div>';
        $print .= '<p>'.implode('</p><p>', $text['task']).'</p>';
        $print .= '</div>';
    }
    
    wp_insert_post(wp_slash([
        'post_title'    => date('d.m.Y H:i:s'),
        'post_parent'   => $form_id,
        'post_content'  => $print,
        'post_status'   => 'publish',
        'post_type'     => 'customforms-lead',
        'post_excerpt' => serialize($data)
    ]));
    
}

function getLeads_forms_amocrm(){
    global $wpdb;
    $forms = $wpdb->get_results( "SELECT * FROM $wpdb->posts WHERE post_type = 'customforms-lead' AND post_status = 'publish' ORDER BY ID DESC", 'ARRAY_A' );
    if($forms){
        foreach ( $forms as $key => $form ) {
            $forms[$key]['post_date'] = date('d.m.Y H:i', strtotime($form['post_date']));
        }
    }
    return $forms;
}

function getLeadsByForm_forms_amocrm($form_id){
    global $wpdb;
    return $wpdb->get_var( "SELECT COUNT(*) FROM $wpdb->posts WHERE post_type = 'customforms-lead' AND post_status = 'publish' AND post_parent = '".$form_id."'" );
}

function get_custom_forms_amocrm(){
    global $wpdb;
    $forms = $wpdb->get_results( "SELECT * FROM $wpdb->posts WHERE post_type = 'customforms-amocrm' AND post_status = 'publish' ORDER BY ID DESC", 'ARRAY_A' );
    if($forms){
        foreach ( $forms as $key => $form ) {
            $forms[$key]['post_date'] = date('d.m.Y H:i', strtotime($form['post_date']));
        }
    }
    return $forms;
}

// возвращает ключи формы
function getFormKeys($form_id){
    $form = get_post($form_id, 'ARRAY_A');
    return $form ? explode(',', $form['post_excerpt']) : [];    
}

// возвращает значения формы
function getFormFieldValues($form_id){
    $form = get_post($form_id, 'ARRAY_A');
    return $form ? unserialize($form['post_content']) : [];    
}

// ищет форму по ключам
function findCustomForm_forms_amocrm($keys = ''){
    global $wpdb;
    $form = $wpdb->get_row( "SELECT * FROM $wpdb->posts WHERE post_type = 'customforms-amocrm' AND post_status = 'publish' AND post_excerpt = '".$keys."'", 'ARRAY_A' );
    if($form){
        $form['post_date'] = date('d.m.Y H:i', strtotime($form['post_date']));
    }
    return $form;
}

function getAmoFields_forms_amocrm(){
    $data = ['action' => 'getAmoCF', 'url' => $_SERVER['HTTP_HOST']];
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_URL, 'https://devamo.ru/customforms/ajax');
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
    $output = curl_exec($curl);
    curl_close($curl);
    $output = json_decode($output, true);
	if(isset($output['status']) and $output['status']){
        update_option( 'customforms-amocrm-settings', $output['settings'] );
	}
	return isset($output['settings']) ? $output['settings'] : false;
}

function customforms_amocrm_admin() {
	add_options_page(__( 'Integration custom forms with amoCRM', 'customforms-amocrm' ), __( 'Integration custom forms with amoCRM', 'customforms-amocrm' ), 'manage_options', 'customforms-amocrm', 'forms_amocrm_settings_page');
}
function forms_amocrm_settings_page(){
	require_once (__DIR__ . '/admin.php');;
}

function customforms_amocrm_save_utm_to_cookie() {
    $date = time()+3600*24*30;
    $options = get_option('customforms-amocrm-settings');
    $utms = isset($options['utm_fields']) ? $options['utm_fields'] : false;
    if($utms){
        foreach($utms as $utm){
            if(isset($_GET[$utm])) setcookie($utm, $_GET[$utm], $date, "/"); 
        }
    }
}

function customforms_amocrm_deactivate(){
    delete_option('customforms-amocrm');
    delete_option('customforms-amocrm-settings');
}

function customforms_amocrm_activate(){
    if( !getAmoFields_forms_amocrm() ){
        exit('Website '.$_SERVER['HTTP_HOST'].__( ' not added in amoCRM widget settings! <br>Go to amoCRM, select amoMarket from the menu on the left > Installed, then find "Contact Form 7 wordpress" and click on it, in the pop-up window add your site to the corresponding field.<br>Technical support amo@devamo.ru or telegram @bmite', 'customforms-amocrm' ) );
    }
}

add_filter('plugin_action_links', 'forms_amocrm_links', 10, 2);
function forms_amocrm_links($actions, $plugin_file ) {
	if( false === strpos( $plugin_file, 'customforms-amocrm' ) ){
        return $actions;
    }
	$settings_link = '<a href="/wp-admin/options-general.php?page=customforms-amocrm' .'">'.__( 'Settings', 'customforms-amocrm' ).'</a>'; 
	array_unshift( $actions, $settings_link ); 
	return $actions; 
}

function customforms_amocrm_scripts( $hook_suffix ) {
	if ( false === strpos( $hook_suffix, 'customforms-amocrm' ) ) {
		return;
	}
	wp_enqueue_script('customforms-amocrm', plugins_url( 'customforms-amocrm/js/main.js' ), '', filemtime( __DIR__ . ('/js/main.js') ) ,true);
    wp_enqueue_style( 'customforms-amocrm', plugins_url( 'customforms-amocrm/css/main.css' ), null, filemtime( __DIR__ . ('/css/main.css') ), 'all' );

}

function customforms_amocrm_footer(){

    $post_id = get_the_ID();
    $settings = get_option('customforms-amocrm');

    $exclude = isset($settings['urls_disabled']) ? $settings['urls_disabled'] : '';
    $exclude = preg_replace("/[^,0-9]/", '', $exclude);
    $exclude = explode(',', $exclude);

    if( !$exclude or in_array($post_id, $exclude) ){
        return false;
    }

    ?>
<script>
document.addEventListener('click', function(event) {
    if (event.target.matches('form:not(.form_exclude):not(.wpcf7-form):not(.wpforms-form):not(#loginform):not(.checkout) [type=submit]:not(disabled)')) {
        var submit = event.target; // кнопка отправки
        //submit.disabled = true; // блокируем кнопку сразу после клика на неё
        var data = new FormData(submit.closest('form')); // данные формы
        data.append('action', 'forms_amocrm');
        var xhr = new XMLHttpRequest();
        xhr.open('POST', '/wp-admin/admin-ajax.php');
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onload = function() {
            if (xhr.status === 200) {
                //submit.disabled = false; // разблокируем кнопку
                var response = JSON.parse(xhr.responseText);
                if (response.okk === 'okk') {
                // действие
                }
            } else {
                console.log('Request failed.  Returned status of ' + xhr.status);
            }
        };
        xhr.send(new URLSearchParams(data).toString());
    }
});
</script>
<?php 
}

function newForm_forms_amocrm(){
    $post = $_POST;
    if(!$post){
        echo json_encode(['status' => 0, 'message' => 'Нет данных']);
        wp_die();
    }

    // елементор
    if(isset($post['form_fields'])){
        $form_fields = $post['form_fields']; 
        $post = $form_fields;
    }

    $keys = implode(',', array_keys($post));
    $form = findCustomForm_forms_amocrm($keys);
    if($form){
        wp_update_post(wp_slash([
            'ID' => $form['ID'],
            'post_content' => serialize($post),
            'post_excerpt' => $keys,
        ]));
        
        $required = customFormsComplete_forms_amocrm($form['ID'], $post);

        if( $required ){
            echo json_encode(['status' => 0, 'message' => 'Не заполнены обязательные поля: '.implode(', ', $required)]);
        }
        
    }else{
        wp_insert_post(wp_slash([
            'post_title'    => 'Новая форма '.date('d.m.Y H:i:s'),
            'post_content'  => serialize($post),
            'post_status'   => 'publish',
            'post_type'     => 'customforms-amocrm',
            'post_excerpt'  => $keys,
        ]));
        //echo json_encode(['status' => 1, 'message' => 'Форма создана']);
    }
    wp_die();
}
add_action( 'wp_ajax_forms_amocrm', 'newForm_forms_amocrm' );
add_action( 'wp_ajax_nopriv_forms_amocrm', 'newForm_forms_amocrm' );

function delete_lead_forms_amocrm(){
    $post = $_POST;
    if(!$post or !$post['lead_id']){
        echo json_encode(['status' => 0, 'message' => 'Нет данных']);
        wp_die();
    }
    $post_obj = wp_delete_post($post['lead_id'], true);
    echo json_encode(['status' => ($post_obj ? 1 : 0)]);
    wp_die();
}
add_action( 'wp_ajax_delete_lead', 'delete_lead_forms_amocrm' );

function testing_forms_amocrm(){
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_URL, 'https://devamo.ru/customforms/version');
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query(['url' => $_SERVER['HTTP_HOST']]));
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
    $output = curl_exec($curl);
    curl_close($curl);
    $output = json_decode($output, true);
    return $output;
}

// Добавляет ссылку в админ бар сверху
add_action( 'admin_bar_menu', 'admin_bar_menu_forms_amocrm', 90 );
function admin_bar_menu_forms_amocrm( $wp_admin_bar ) {
	$wp_admin_bar->add_menu( array(
		'id'    => 'customforms-amocrm',
		'title' => '<span class="ab-label">'.__( 'Integration forms with amoCRM', 'customforms-amocrm' ).'</span>',
		'href'  => '/wp-admin/options-general.php?page=customforms-amocrm',
	) );

}

// перевод
function customforms_amocrm_load_lang() {
    load_plugin_textdomain( 'customforms-amocrm', false, dirname( plugin_basename( __FILE__ ) ) . '/lang' ); 
}
